package com.company.tp07_04_remotetodoapp2.viewmodel;

import android.app.Application;

import androidx.annotation.NonNull;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.MutableLiveData;

import com.company.tp07_04_remotetodoapp2.remote.Todo;
import com.company.tp07_04_remotetodoapp2.repository.TodoRepo;

import java.util.List;

public class TodoViewModel extends AndroidViewModel {

    private TodoRepo todoRepo;
    private MutableLiveData<List<Todo>> todoList;
    public TodoViewModel(@NonNull Application application) {
        super(application);
        todoRepo = TodoRepo.getInstance(application);
        todoList = todoRepo.getTodoList();
    }
    public MutableLiveData<List<Todo>> getTodoList() {
        return todoList;
    }

}
